%
%-------------------------------------------------------------
%
%	ROBOTRAN - Version 6.6 (build : february 22, 2008)
%
%	Copyright 
%	Universit catholique de Louvain 
%	Dpartement de Mcanique 
%	Unit de Production Mcanique et Machines 
%	2, Place du Levant 
%	1348 Louvain-la-Neuve 
%	http://www.robotran.be// 
%
%	==> Generation Date : Tue Oct 14 13:53:55 2008
%
%	==> Project name : five_point_suspension_matlab
%	==> using XML input file 
%
%	==> Number of joints : 17
%
%	==> Function : F 6 : Sensors Kinematical Informations (sens) 
%	==> Flops complexity : 851
%
%	==> Generation Time :  0.010 seconds
%	==> Post-Processing :  0.020 seconds
%
%-------------------------------------------------------------
%
function [sens] = gensensor(s,tsim,usrfun,isens)

 sens.P = zeros(3,1);
 sens.R = zeros(3,3);
 sens.V = zeros(3,1);
 sens.OM = zeros(3,1);
 sens.A = zeros(3,1);
 sens.OMP = zeros(3,1);
 sens.J = zeros(6,17);

q = s.q; 
qd = s.qd; 
qdd = s.qdd; 
frc = s.frc; 
trq = s.trq; 

% === begin imp_aux === 

% === end imp_aux === 

% ===== BEGIN task 0 ===== 
 
% Sensor Kinematics 



% = = Block_0_0_0_0_0_2 = = 
 
% Trigonometric Variables  

C2 = cos(q(2));
S2 = sin(q(2));
C3 = cos(q(3));
S3 = sin(q(3));

% = = Block_0_0_0_0_0_3 = = 
 
% Trigonometric Variables  

C4 = cos(q(4));
S4 = sin(q(4));
C5 = cos(q(5));
S5 = sin(q(5));

% = = Block_0_0_0_0_0_4 = = 
 
% Trigonometric Variables  

C7 = cos(q(7));
S7 = sin(q(7));
C8 = cos(q(8));
S8 = sin(q(8));

% = = Block_0_0_0_0_0_5 = = 
 
% Trigonometric Variables  

C9 = cos(q(9));
S9 = sin(q(9));
C10 = cos(q(10));
S10 = sin(q(10));

% = = Block_0_0_0_0_0_6 = = 
 
% Trigonometric Variables  

C11 = cos(q(11));
S11 = sin(q(11));
C12 = cos(q(12));
S12 = sin(q(12));
C13 = cos(q(13));
S13 = sin(q(13));
C14 = cos(q(14));
S14 = sin(q(14));
C15 = cos(q(15));
S15 = sin(q(15));
C16 = cos(q(16));
S16 = sin(q(16));

% ====== END Task 0 ====== 

% ===== BEGIN task 1 ===== 
 
switch isens

 
% 
case 1, 


% = = Block_1_0_0_1_1_0 = = 
 
% Symbolic Outputs  

sens.P(3) = q(1);
sens.R(1,1) = (1.0);
sens.R(2,2) = (1.0);
sens.R(3,3) = (1.0);
sens.V(3) = qd(1);
sens.A(3) = qdd(1);
 
% 
case 2, 


% = = Block_1_0_0_2_0_2 = = 
 
% Sensor Kinematics 


POcp1_32 = q(1)+s.dpt(3,2);

% = = Block_1_0_0_2_1_0 = = 
 
% Symbolic Outputs  

sens.P(1) = s.dpt(1,2);
sens.P(2) = s.dpt(2,2);
sens.P(3) = POcp1_32;
sens.R(1,1) = (1.0);
sens.R(2,2) = C2;
sens.R(2,3) = S2;
sens.R(3,2) = -S2;
sens.R(3,3) = C2;
sens.V(3) = qd(1);
sens.OM(1) = qd(2);
sens.A(3) = qdd(1);
sens.OMP(1) = qdd(2);
 
% 
case 3, 


% = = Block_1_0_0_3_0_2 = = 
 
% Sensor Kinematics 


ROcp2_23 = C2*S3;
ROcp2_33 = S2*S3;
ROcp2_53 = C2*C3;
ROcp2_63 = S2*C3;
POcp2_32 = q(1)+s.dpt(3,2);
OMcp2_23 = -qd(3)*S2;
OMcp2_33 = qd(3)*C2;
OPcp2_23 = -(qdd(3)*S2+qd(2)*qd(3)*C2);
OPcp2_33 = qdd(3)*C2-qd(2)*qd(3)*S2;

% = = Block_1_0_0_3_1_0 = = 
 
% Symbolic Outputs  

sens.P(1) = s.dpt(1,2);
sens.P(2) = s.dpt(2,2);
sens.P(3) = POcp2_32;
sens.R(1,1) = C3;
sens.R(1,2) = ROcp2_23;
sens.R(1,3) = ROcp2_33;
sens.R(2,1) = -S3;
sens.R(2,2) = ROcp2_53;
sens.R(2,3) = ROcp2_63;
sens.R(3,2) = -S2;
sens.R(3,3) = C2;
sens.V(3) = qd(1);
sens.OM(1) = qd(2);
sens.OM(2) = OMcp2_23;
sens.OM(3) = OMcp2_33;
sens.A(3) = qdd(1);
sens.OMP(1) = qdd(2);
sens.OMP(2) = OPcp2_23;
sens.OMP(3) = OPcp2_33;
 
% 
case 4, 


% = = Block_1_0_0_4_0_3 = = 
 
% Sensor Kinematics 


POcp3_34 = q(1)+s.dpt(3,3);

% = = Block_1_0_0_4_1_0 = = 
 
% Symbolic Outputs  

sens.P(1) = s.dpt(1,3);
sens.P(2) = s.dpt(2,3);
sens.P(3) = POcp3_34;
sens.R(1,1) = (1.0);
sens.R(2,2) = C4;
sens.R(2,3) = S4;
sens.R(3,2) = -S4;
sens.R(3,3) = C4;
sens.V(3) = qd(1);
sens.OM(1) = qd(4);
sens.A(3) = qdd(1);
sens.OMP(1) = qdd(4);
 
% 
case 5, 


% = = Block_1_0_0_5_0_3 = = 
 
% Sensor Kinematics 


ROcp4_25 = C4*S5;
ROcp4_35 = S4*S5;
ROcp4_55 = C4*C5;
ROcp4_65 = S4*C5;
POcp4_34 = q(1)+s.dpt(3,3);
OMcp4_25 = -qd(5)*S4;
OMcp4_35 = qd(5)*C4;
OPcp4_25 = -(qdd(5)*S4+qd(4)*qd(5)*C4);
OPcp4_35 = qdd(5)*C4-qd(4)*qd(5)*S4;

% = = Block_1_0_0_5_1_0 = = 
 
% Symbolic Outputs  

sens.P(1) = s.dpt(1,3);
sens.P(2) = s.dpt(2,3);
sens.P(3) = POcp4_34;
sens.R(1,1) = C5;
sens.R(1,2) = ROcp4_25;
sens.R(1,3) = ROcp4_35;
sens.R(2,1) = -S5;
sens.R(2,2) = ROcp4_55;
sens.R(2,3) = ROcp4_65;
sens.R(3,2) = -S4;
sens.R(3,3) = C4;
sens.V(3) = qd(1);
sens.OM(1) = qd(4);
sens.OM(2) = OMcp4_25;
sens.OM(3) = OMcp4_35;
sens.A(3) = qdd(1);
sens.OMP(1) = qdd(4);
sens.OMP(2) = OPcp4_25;
sens.OMP(3) = OPcp4_35;
 
% 
case 6, 


% = = Block_1_0_0_6_0_4 = = 
 
% Sensor Kinematics 


POcp5_36 = q(1)+s.dpt(3,4);

% = = Block_1_0_0_6_1_0 = = 
 
% Symbolic Outputs  

sens.P(1) = s.dpt(1,4);
sens.P(2) = q(6);
sens.P(3) = POcp5_36;
sens.R(1,1) = (1.0);
sens.R(2,2) = (1.0);
sens.R(3,3) = (1.0);
sens.V(2) = qd(6);
sens.V(3) = qd(1);
sens.A(2) = qdd(6);
sens.A(3) = qdd(1);
 
% 
case 7, 


% = = Block_1_0_0_7_0_4 = = 
 
% Sensor Kinematics 


POcp6_36 = q(1)+s.dpt(3,4);
POcp6_27 = q(6)+s.dpt(2,10);

% = = Block_1_0_0_7_1_0 = = 
 
% Symbolic Outputs  

sens.P(1) = s.dpt(1,4);
sens.P(2) = POcp6_27;
sens.P(3) = POcp6_36;
sens.R(1,1) = (1.0);
sens.R(2,2) = C7;
sens.R(2,3) = S7;
sens.R(3,2) = -S7;
sens.R(3,3) = C7;
sens.V(2) = qd(6);
sens.V(3) = qd(1);
sens.OM(1) = qd(7);
sens.A(2) = qdd(6);
sens.A(3) = qdd(1);
sens.OMP(1) = qdd(7);
 
% 
case 8, 


% = = Block_1_0_0_8_0_4 = = 
 
% Sensor Kinematics 


ROcp7_28 = C7*S8;
ROcp7_38 = S7*S8;
ROcp7_58 = C7*C8;
ROcp7_68 = S7*C8;
POcp7_36 = q(1)+s.dpt(3,4);
POcp7_27 = q(6)+s.dpt(2,10);
OMcp7_28 = -qd(8)*S7;
OMcp7_38 = qd(8)*C7;
OPcp7_28 = -(qdd(8)*S7+qd(7)*qd(8)*C7);
OPcp7_38 = qdd(8)*C7-qd(7)*qd(8)*S7;

% = = Block_1_0_0_8_1_0 = = 
 
% Symbolic Outputs  

sens.P(1) = s.dpt(1,4);
sens.P(2) = POcp7_27;
sens.P(3) = POcp7_36;
sens.R(1,1) = C8;
sens.R(1,2) = ROcp7_28;
sens.R(1,3) = ROcp7_38;
sens.R(2,1) = -S8;
sens.R(2,2) = ROcp7_58;
sens.R(2,3) = ROcp7_68;
sens.R(3,2) = -S7;
sens.R(3,3) = C7;
sens.V(2) = qd(6);
sens.V(3) = qd(1);
sens.OM(1) = qd(7);
sens.OM(2) = OMcp7_28;
sens.OM(3) = OMcp7_38;
sens.A(2) = qdd(6);
sens.A(3) = qdd(1);
sens.OMP(1) = qdd(7);
sens.OMP(2) = OPcp7_28;
sens.OMP(3) = OPcp7_38;
 
% 
case 9, 


% = = Block_1_0_0_9_0_5 = = 
 
% Sensor Kinematics 


POcp8_39 = q(1)+s.dpt(3,5);

% = = Block_1_0_0_9_1_0 = = 
 
% Symbolic Outputs  

sens.P(1) = s.dpt(1,5);
sens.P(2) = s.dpt(2,5);
sens.P(3) = POcp8_39;
sens.R(1,1) = (1.0);
sens.R(2,2) = C9;
sens.R(2,3) = S9;
sens.R(3,2) = -S9;
sens.R(3,3) = C9;
sens.V(3) = qd(1);
sens.OM(1) = qd(9);
sens.A(3) = qdd(1);
sens.OMP(1) = qdd(9);
 
% 
case 10, 


% = = Block_1_0_0_10_0_5 = = 
 
% Sensor Kinematics 


ROcp9_210 = S10*C9;
ROcp9_310 = S10*S9;
ROcp9_510 = C10*C9;
ROcp9_610 = C10*S9;
POcp9_39 = q(1)+s.dpt(3,5);
OMcp9_210 = -qd(10)*S9;
OMcp9_310 = qd(10)*C9;
OPcp9_210 = -(qdd(10)*S9+qd(10)*qd(9)*C9);
OPcp9_310 = qdd(10)*C9-qd(10)*qd(9)*S9;

% = = Block_1_0_0_10_1_0 = = 
 
% Symbolic Outputs  

sens.P(1) = s.dpt(1,5);
sens.P(2) = s.dpt(2,5);
sens.P(3) = POcp9_39;
sens.R(1,1) = C10;
sens.R(1,2) = ROcp9_210;
sens.R(1,3) = ROcp9_310;
sens.R(2,1) = -S10;
sens.R(2,2) = ROcp9_510;
sens.R(2,3) = ROcp9_610;
sens.R(3,2) = -S9;
sens.R(3,3) = C9;
sens.V(3) = qd(1);
sens.OM(1) = qd(9);
sens.OM(2) = OMcp9_210;
sens.OM(3) = OMcp9_310;
sens.A(3) = qdd(1);
sens.OMP(1) = qdd(9);
sens.OMP(2) = OPcp9_210;
sens.OMP(3) = OPcp9_310;
 
% 
case 11, 


% = = Block_1_0_0_11_0_6 = = 
 
% Sensor Kinematics 


POcp10_311 = q(1)+s.dpt(3,6);

% = = Block_1_0_0_11_1_0 = = 
 
% Symbolic Outputs  

sens.P(1) = s.dpt(1,6);
sens.P(2) = s.dpt(2,6);
sens.P(3) = POcp10_311;
sens.R(1,1) = (1.0);
sens.R(2,2) = C11;
sens.R(2,3) = S11;
sens.R(3,2) = -S11;
sens.R(3,3) = C11;
sens.V(3) = qd(1);
sens.OM(1) = qd(11);
sens.A(3) = qdd(1);
sens.OMP(1) = qdd(11);
 
% 
case 12, 


% = = Block_1_0_0_12_0_6 = = 
 
% Sensor Kinematics 


ROcp11_212 = C11*S12;
ROcp11_312 = S11*S12;
ROcp11_512 = C11*C12;
ROcp11_612 = S11*C12;
POcp11_311 = q(1)+s.dpt(3,6);
OMcp11_212 = -qd(12)*S11;
OMcp11_312 = qd(12)*C11;
OPcp11_212 = -(qdd(12)*S11+qd(11)*qd(12)*C11);
OPcp11_312 = qdd(12)*C11-qd(11)*qd(12)*S11;

% = = Block_1_0_0_12_1_0 = = 
 
% Symbolic Outputs  

sens.P(1) = s.dpt(1,6);
sens.P(2) = s.dpt(2,6);
sens.P(3) = POcp11_311;
sens.R(1,1) = C12;
sens.R(1,2) = ROcp11_212;
sens.R(1,3) = ROcp11_312;
sens.R(2,1) = -S12;
sens.R(2,2) = ROcp11_512;
sens.R(2,3) = ROcp11_612;
sens.R(3,2) = -S11;
sens.R(3,3) = C11;
sens.V(3) = qd(1);
sens.OM(1) = qd(11);
sens.OM(2) = OMcp11_212;
sens.OM(3) = OMcp11_312;
sens.A(3) = qdd(1);
sens.OMP(1) = qdd(11);
sens.OMP(2) = OPcp11_212;
sens.OMP(3) = OPcp11_312;
 
% 
case 13, 


% = = Block_1_0_0_13_0_6 = = 
 
% Sensor Kinematics 


ROcp12_212 = C11*S12;
ROcp12_312 = S11*S12;
ROcp12_512 = C11*C12;
ROcp12_612 = S11*C12;
ROcp12_413 = -S12*C13;
ROcp12_513 = ROcp12_512*C13-S11*S13;
ROcp12_613 = ROcp12_612*C13+C11*S13;
ROcp12_713 = S12*S13;
ROcp12_813 = -(ROcp12_512*S13+S11*C13);
ROcp12_913 = -(ROcp12_612*S13-C11*C13);
OMcp12_212 = -qd(12)*S11;
OMcp12_312 = qd(12)*C11;
OPcp12_212 = -(qdd(12)*S11+qd(11)*qd(12)*C11);
OPcp12_312 = qdd(12)*C11-qd(11)*qd(12)*S11;
RLcp12_113 = -s.dpt(2,13)*S12;
RLcp12_213 = ROcp12_512*s.dpt(2,13);
RLcp12_313 = ROcp12_612*s.dpt(2,13);
POcp12_113 = RLcp12_113+s.dpt(1,6);
POcp12_213 = RLcp12_213+s.dpt(2,6);
POcp12_313 = RLcp12_313+q(1)+s.dpt(3,6);
OMcp12_113 = qd(11)+qd(13)*C12;
OMcp12_213 = OMcp12_212+ROcp12_212*qd(13);
OMcp12_313 = OMcp12_312+ROcp12_312*qd(13);
ORcp12_113 = -qd(12)*s.dpt(2,13)*C12;
ORcp12_213 = OMcp12_312*RLcp12_113-RLcp12_313*qd(11);
ORcp12_313 = -(OMcp12_212*RLcp12_113-RLcp12_213*qd(11));
VIcp12_313 = ORcp12_313+qd(1);
OPcp12_113 = qdd(11)+qdd(13)*C12-qd(12)*qd(13)*S12;
OPcp12_213 = OPcp12_212+ROcp12_212*qdd(13)+qd(13)*(OMcp12_312*C12-ROcp12_312*qd(11));
OPcp12_313 = OPcp12_312+ROcp12_312*qdd(13)-qd(13)*(OMcp12_212*C12-ROcp12_212*qd(11));
ACcp12_113 = OMcp12_212*ORcp12_313-OMcp12_312*ORcp12_213+OPcp12_212*RLcp12_313-OPcp12_312*RLcp12_213;
ACcp12_213 = OMcp12_312*ORcp12_113+OPcp12_312*RLcp12_113-ORcp12_313*qd(11)-RLcp12_313*qdd(11);
ACcp12_313 = qdd(1)-OMcp12_212*ORcp12_113-OPcp12_212*RLcp12_113+ORcp12_213*qd(11)+RLcp12_213*qdd(11);

% = = Block_1_0_0_13_1_0 = = 
 
% Symbolic Outputs  

sens.P(1) = POcp12_113;
sens.P(2) = POcp12_213;
sens.P(3) = POcp12_313;
sens.R(1,1) = C12;
sens.R(1,2) = ROcp12_212;
sens.R(1,3) = ROcp12_312;
sens.R(2,1) = ROcp12_413;
sens.R(2,2) = ROcp12_513;
sens.R(2,3) = ROcp12_613;
sens.R(3,1) = ROcp12_713;
sens.R(3,2) = ROcp12_813;
sens.R(3,3) = ROcp12_913;
sens.V(1) = ORcp12_113;
sens.V(2) = ORcp12_213;
sens.V(3) = VIcp12_313;
sens.OM(1) = OMcp12_113;
sens.OM(2) = OMcp12_213;
sens.OM(3) = OMcp12_313;
sens.A(1) = ACcp12_113;
sens.A(2) = ACcp12_213;
sens.A(3) = ACcp12_313;
sens.OMP(1) = OPcp12_113;
sens.OMP(2) = OPcp12_213;
sens.OMP(3) = OPcp12_313;
 
% 
case 14, 


% = = Block_1_0_0_14_0_6 = = 
 
% Sensor Kinematics 


ROcp13_212 = C11*S12;
ROcp13_312 = S11*S12;
ROcp13_512 = C11*C12;
ROcp13_612 = S11*C12;
ROcp13_413 = -S12*C13;
ROcp13_513 = ROcp13_512*C13-S11*S13;
ROcp13_613 = ROcp13_612*C13+C11*S13;
ROcp13_713 = S12*S13;
ROcp13_813 = -(ROcp13_512*S13+S11*C13);
ROcp13_913 = -(ROcp13_612*S13-C11*C13);
ROcp13_114 = -(ROcp13_713*S14-C12*C14);
ROcp13_214 = ROcp13_212*C14-ROcp13_813*S14;
ROcp13_314 = ROcp13_312*C14-ROcp13_913*S14;
ROcp13_714 = ROcp13_713*C14+C12*S14;
ROcp13_814 = ROcp13_212*S14+ROcp13_813*C14;
ROcp13_914 = ROcp13_312*S14+ROcp13_913*C14;
OMcp13_212 = -qd(12)*S11;
OMcp13_312 = qd(12)*C11;
OPcp13_212 = -(qdd(12)*S11+qd(11)*qd(12)*C11);
OPcp13_312 = qdd(12)*C11-qd(11)*qd(12)*S11;
RLcp13_113 = -s.dpt(2,13)*S12;
RLcp13_213 = ROcp13_512*s.dpt(2,13);
RLcp13_313 = ROcp13_612*s.dpt(2,13);
POcp13_113 = RLcp13_113+s.dpt(1,6);
POcp13_213 = RLcp13_213+s.dpt(2,6);
POcp13_313 = RLcp13_313+q(1)+s.dpt(3,6);
OMcp13_113 = qd(11)+qd(13)*C12;
OMcp13_213 = OMcp13_212+ROcp13_212*qd(13);
OMcp13_313 = OMcp13_312+ROcp13_312*qd(13);
ORcp13_113 = -qd(12)*s.dpt(2,13)*C12;
ORcp13_213 = OMcp13_312*RLcp13_113-RLcp13_313*qd(11);
ORcp13_313 = -(OMcp13_212*RLcp13_113-RLcp13_213*qd(11));
VIcp13_313 = ORcp13_313+qd(1);
ACcp13_113 = OMcp13_212*ORcp13_313-OMcp13_312*ORcp13_213+OPcp13_212*RLcp13_313-OPcp13_312*RLcp13_213;
ACcp13_213 = OMcp13_312*ORcp13_113+OPcp13_312*RLcp13_113-ORcp13_313*qd(11)-RLcp13_313*qdd(11);
ACcp13_313 = qdd(1)-OMcp13_212*ORcp13_113-OPcp13_212*RLcp13_113+ORcp13_213*qd(11)+RLcp13_213*qdd(11);
OMcp13_114 = OMcp13_113+ROcp13_413*qd(14);
OMcp13_214 = OMcp13_213+ROcp13_513*qd(14);
OMcp13_314 = OMcp13_313+ROcp13_613*qd(14);
OPcp13_114 = qdd(11)+ROcp13_413*qdd(14)+qdd(13)*C12-qd(12)*qd(13)*S12+qd(14)*(OMcp13_213*ROcp13_613-OMcp13_313*ROcp13_513);
OPcp13_214 = OPcp13_212+ROcp13_212*qdd(13)+ROcp13_513*qdd(14)+qd(13)*(OMcp13_312*C12-ROcp13_312*qd(11))-qd(14)*(OMcp13_113*ROcp13_613-...
 OMcp13_313*ROcp13_413);
OPcp13_314 = OPcp13_312+ROcp13_312*qdd(13)+ROcp13_613*qdd(14)-qd(13)*(OMcp13_212*C12-ROcp13_212*qd(11))+qd(14)*(OMcp13_113*ROcp13_513-...
 OMcp13_213*ROcp13_413);

% = = Block_1_0_0_14_1_0 = = 
 
% Symbolic Outputs  

sens.P(1) = POcp13_113;
sens.P(2) = POcp13_213;
sens.P(3) = POcp13_313;
sens.R(1,1) = ROcp13_114;
sens.R(1,2) = ROcp13_214;
sens.R(1,3) = ROcp13_314;
sens.R(2,1) = ROcp13_413;
sens.R(2,2) = ROcp13_513;
sens.R(2,3) = ROcp13_613;
sens.R(3,1) = ROcp13_714;
sens.R(3,2) = ROcp13_814;
sens.R(3,3) = ROcp13_914;
sens.V(1) = ORcp13_113;
sens.V(2) = ORcp13_213;
sens.V(3) = VIcp13_313;
sens.OM(1) = OMcp13_114;
sens.OM(2) = OMcp13_214;
sens.OM(3) = OMcp13_314;
sens.A(1) = ACcp13_113;
sens.A(2) = ACcp13_213;
sens.A(3) = ACcp13_313;
sens.OMP(1) = OPcp13_114;
sens.OMP(2) = OPcp13_214;
sens.OMP(3) = OPcp13_314;
 
% 
case 15, 


% = = Block_1_0_0_15_0_6 = = 
 
% Sensor Kinematics 


ROcp14_212 = C11*S12;
ROcp14_312 = S11*S12;
ROcp14_512 = C11*C12;
ROcp14_612 = S11*C12;
ROcp14_413 = -S12*C13;
ROcp14_513 = ROcp14_512*C13-S11*S13;
ROcp14_613 = ROcp14_612*C13+C11*S13;
ROcp14_713 = S12*S13;
ROcp14_813 = -(ROcp14_512*S13+S11*C13);
ROcp14_913 = -(ROcp14_612*S13-C11*C13);
ROcp14_114 = -(ROcp14_713*S14-C12*C14);
ROcp14_214 = ROcp14_212*C14-ROcp14_813*S14;
ROcp14_314 = ROcp14_312*C14-ROcp14_913*S14;
ROcp14_714 = ROcp14_713*C14+C12*S14;
ROcp14_814 = ROcp14_212*S14+ROcp14_813*C14;
ROcp14_914 = ROcp14_312*S14+ROcp14_913*C14;
ROcp14_115 = ROcp14_114*C15+ROcp14_413*S15;
ROcp14_215 = ROcp14_214*C15+ROcp14_513*S15;
ROcp14_315 = ROcp14_314*C15+ROcp14_613*S15;
ROcp14_415 = -(ROcp14_114*S15-ROcp14_413*C15);
ROcp14_515 = -(ROcp14_214*S15-ROcp14_513*C15);
ROcp14_615 = -(ROcp14_314*S15-ROcp14_613*C15);
OMcp14_212 = -qd(12)*S11;
OMcp14_312 = qd(12)*C11;
OPcp14_212 = -(qdd(12)*S11+qd(11)*qd(12)*C11);
OPcp14_312 = qdd(12)*C11-qd(11)*qd(12)*S11;
RLcp14_113 = -s.dpt(2,13)*S12;
RLcp14_213 = ROcp14_512*s.dpt(2,13);
RLcp14_313 = ROcp14_612*s.dpt(2,13);
POcp14_113 = RLcp14_113+s.dpt(1,6);
POcp14_213 = RLcp14_213+s.dpt(2,6);
POcp14_313 = RLcp14_313+q(1)+s.dpt(3,6);
OMcp14_113 = qd(11)+qd(13)*C12;
OMcp14_213 = OMcp14_212+ROcp14_212*qd(13);
OMcp14_313 = OMcp14_312+ROcp14_312*qd(13);
ORcp14_113 = -qd(12)*s.dpt(2,13)*C12;
ORcp14_213 = OMcp14_312*RLcp14_113-RLcp14_313*qd(11);
ORcp14_313 = -(OMcp14_212*RLcp14_113-RLcp14_213*qd(11));
VIcp14_313 = ORcp14_313+qd(1);
ACcp14_113 = OMcp14_212*ORcp14_313-OMcp14_312*ORcp14_213+OPcp14_212*RLcp14_313-OPcp14_312*RLcp14_213;
ACcp14_213 = OMcp14_312*ORcp14_113+OPcp14_312*RLcp14_113-ORcp14_313*qd(11)-RLcp14_313*qdd(11);
ACcp14_313 = qdd(1)-OMcp14_212*ORcp14_113-OPcp14_212*RLcp14_113+ORcp14_213*qd(11)+RLcp14_213*qdd(11);
OMcp14_114 = OMcp14_113+ROcp14_413*qd(14);
OMcp14_214 = OMcp14_213+ROcp14_513*qd(14);
OMcp14_314 = OMcp14_313+ROcp14_613*qd(14);
OMcp14_115 = OMcp14_114+ROcp14_714*qd(15);
OMcp14_215 = OMcp14_214+ROcp14_814*qd(15);
OMcp14_315 = OMcp14_314+ROcp14_914*qd(15);
OPcp14_115 = qdd(11)+ROcp14_413*qdd(14)+ROcp14_714*qdd(15)+qdd(13)*C12-qd(12)*qd(13)*S12+qd(14)*(OMcp14_213*ROcp14_613-OMcp14_313*ROcp14_513)+...
 qd(15)*(OMcp14_214*ROcp14_914-OMcp14_314*ROcp14_814);
OPcp14_215 = OPcp14_212+ROcp14_212*qdd(13)+ROcp14_513*qdd(14)+ROcp14_814*qdd(15)+qd(13)*(OMcp14_312*C12-ROcp14_312*qd(11))-qd(14)*(OMcp14_113*...
 ROcp14_613-OMcp14_313*ROcp14_413)-qd(15)*(OMcp14_114*ROcp14_914-OMcp14_314*ROcp14_714);
OPcp14_315 = OPcp14_312+ROcp14_312*qdd(13)+ROcp14_613*qdd(14)+ROcp14_914*qdd(15)-qd(13)*(OMcp14_212*C12-ROcp14_212*qd(11))+qd(14)*(OMcp14_113*...
 ROcp14_513-OMcp14_213*ROcp14_413)+qd(15)*(OMcp14_114*ROcp14_814-OMcp14_214*ROcp14_714);

% = = Block_1_0_0_15_1_0 = = 
 
% Symbolic Outputs  

sens.P(1) = POcp14_113;
sens.P(2) = POcp14_213;
sens.P(3) = POcp14_313;
sens.R(1,1) = ROcp14_115;
sens.R(1,2) = ROcp14_215;
sens.R(1,3) = ROcp14_315;
sens.R(2,1) = ROcp14_415;
sens.R(2,2) = ROcp14_515;
sens.R(2,3) = ROcp14_615;
sens.R(3,1) = ROcp14_714;
sens.R(3,2) = ROcp14_814;
sens.R(3,3) = ROcp14_914;
sens.V(1) = ORcp14_113;
sens.V(2) = ORcp14_213;
sens.V(3) = VIcp14_313;
sens.OM(1) = OMcp14_115;
sens.OM(2) = OMcp14_215;
sens.OM(3) = OMcp14_315;
sens.A(1) = ACcp14_113;
sens.A(2) = ACcp14_213;
sens.A(3) = ACcp14_313;
sens.OMP(1) = OPcp14_115;
sens.OMP(2) = OPcp14_215;
sens.OMP(3) = OPcp14_315;
 
% 
case 16, 


% = = Block_1_0_0_16_0_6 = = 
 
% Sensor Kinematics 


ROcp15_212 = C11*S12;
ROcp15_312 = S11*S12;
ROcp15_512 = C11*C12;
ROcp15_612 = S11*C12;
ROcp15_413 = -S12*C13;
ROcp15_513 = ROcp15_512*C13-S11*S13;
ROcp15_613 = ROcp15_612*C13+C11*S13;
ROcp15_713 = S12*S13;
ROcp15_813 = -(ROcp15_512*S13+S11*C13);
ROcp15_913 = -(ROcp15_612*S13-C11*C13);
ROcp15_114 = -(ROcp15_713*S14-C12*C14);
ROcp15_214 = ROcp15_212*C14-ROcp15_813*S14;
ROcp15_314 = ROcp15_312*C14-ROcp15_913*S14;
ROcp15_714 = ROcp15_713*C14+C12*S14;
ROcp15_814 = ROcp15_212*S14+ROcp15_813*C14;
ROcp15_914 = ROcp15_312*S14+ROcp15_913*C14;
ROcp15_115 = ROcp15_114*C15+ROcp15_413*S15;
ROcp15_215 = ROcp15_214*C15+ROcp15_513*S15;
ROcp15_315 = ROcp15_314*C15+ROcp15_613*S15;
ROcp15_415 = -(ROcp15_114*S15-ROcp15_413*C15);
ROcp15_515 = -(ROcp15_214*S15-ROcp15_513*C15);
ROcp15_615 = -(ROcp15_314*S15-ROcp15_613*C15);
ROcp15_116 = ROcp15_115*C16-ROcp15_714*S16;
ROcp15_216 = ROcp15_215*C16-ROcp15_814*S16;
ROcp15_316 = ROcp15_315*C16-ROcp15_914*S16;
ROcp15_716 = ROcp15_115*S16+ROcp15_714*C16;
ROcp15_816 = ROcp15_215*S16+ROcp15_814*C16;
ROcp15_916 = ROcp15_315*S16+ROcp15_914*C16;
OMcp15_212 = -qd(12)*S11;
OMcp15_312 = qd(12)*C11;
OPcp15_212 = -(qdd(12)*S11+qd(11)*qd(12)*C11);
OPcp15_312 = qdd(12)*C11-qd(11)*qd(12)*S11;
RLcp15_113 = -s.dpt(2,13)*S12;
RLcp15_213 = ROcp15_512*s.dpt(2,13);
RLcp15_313 = ROcp15_612*s.dpt(2,13);
OMcp15_113 = qd(11)+qd(13)*C12;
OMcp15_213 = OMcp15_212+ROcp15_212*qd(13);
OMcp15_313 = OMcp15_312+ROcp15_312*qd(13);
ORcp15_113 = -qd(12)*s.dpt(2,13)*C12;
ORcp15_213 = OMcp15_312*RLcp15_113-RLcp15_313*qd(11);
ORcp15_313 = -(OMcp15_212*RLcp15_113-RLcp15_213*qd(11));
OMcp15_114 = OMcp15_113+ROcp15_413*qd(14);
OMcp15_214 = OMcp15_213+ROcp15_513*qd(14);
OMcp15_314 = OMcp15_313+ROcp15_613*qd(14);
OMcp15_115 = OMcp15_114+ROcp15_714*qd(15);
OMcp15_215 = OMcp15_214+ROcp15_814*qd(15);
OMcp15_315 = OMcp15_314+ROcp15_914*qd(15);
OPcp15_115 = qdd(11)+ROcp15_413*qdd(14)+ROcp15_714*qdd(15)+qdd(13)*C12-qd(12)*qd(13)*S12+qd(14)*(OMcp15_213*ROcp15_613-OMcp15_313*ROcp15_513)+...
 qd(15)*(OMcp15_214*ROcp15_914-OMcp15_314*ROcp15_814);
OPcp15_215 = OPcp15_212+ROcp15_212*qdd(13)+ROcp15_513*qdd(14)+ROcp15_814*qdd(15)+qd(13)*(OMcp15_312*C12-ROcp15_312*qd(11))-qd(14)*(OMcp15_113*...
 ROcp15_613-OMcp15_313*ROcp15_413)-qd(15)*(OMcp15_114*ROcp15_914-OMcp15_314*ROcp15_714);
OPcp15_315 = OPcp15_312+ROcp15_312*qdd(13)+ROcp15_613*qdd(14)+ROcp15_914*qdd(15)-qd(13)*(OMcp15_212*C12-ROcp15_212*qd(11))+qd(14)*(OMcp15_113*...
 ROcp15_513-OMcp15_213*ROcp15_413)+qd(15)*(OMcp15_114*ROcp15_814-OMcp15_214*ROcp15_714);
RLcp15_116 = ROcp15_115*s.dpt(1,15)+ROcp15_415*s.dpt(2,15)+ROcp15_714*s.dpt(3,15);
RLcp15_216 = ROcp15_215*s.dpt(1,15)+ROcp15_515*s.dpt(2,15)+ROcp15_814*s.dpt(3,15);
RLcp15_316 = ROcp15_315*s.dpt(1,15)+ROcp15_615*s.dpt(2,15)+ROcp15_914*s.dpt(3,15);
POcp15_116 = RLcp15_113+RLcp15_116+s.dpt(1,6);
POcp15_216 = RLcp15_213+RLcp15_216+s.dpt(2,6);
POcp15_316 = RLcp15_313+RLcp15_316+q(1)+s.dpt(3,6);
OMcp15_116 = OMcp15_115+ROcp15_415*qd(16);
OMcp15_216 = OMcp15_215+ROcp15_515*qd(16);
OMcp15_316 = OMcp15_315+ROcp15_615*qd(16);
ORcp15_116 = OMcp15_215*RLcp15_316-OMcp15_315*RLcp15_216;
ORcp15_216 = -(OMcp15_115*RLcp15_316-OMcp15_315*RLcp15_116);
ORcp15_316 = OMcp15_115*RLcp15_216-OMcp15_215*RLcp15_116;
VIcp15_116 = ORcp15_113+ORcp15_116;
VIcp15_216 = ORcp15_213+ORcp15_216;
VIcp15_316 = ORcp15_313+ORcp15_316+qd(1);
OPcp15_116 = OPcp15_115+ROcp15_415*qdd(16)+qd(16)*(OMcp15_215*ROcp15_615-OMcp15_315*ROcp15_515);
OPcp15_216 = OPcp15_215+ROcp15_515*qdd(16)-qd(16)*(OMcp15_115*ROcp15_615-OMcp15_315*ROcp15_415);
OPcp15_316 = OPcp15_315+ROcp15_615*qdd(16)+qd(16)*(OMcp15_115*ROcp15_515-OMcp15_215*ROcp15_415);
ACcp15_116 = OMcp15_212*ORcp15_313+OMcp15_215*ORcp15_316-OMcp15_312*ORcp15_213-OMcp15_315*ORcp15_216+OPcp15_212*RLcp15_313+OPcp15_215*...
 RLcp15_316-OPcp15_312*RLcp15_213-OPcp15_315*RLcp15_216;
ACcp15_216 = OMcp15_312*ORcp15_113+OPcp15_312*RLcp15_113-ORcp15_313*qd(11)-RLcp15_313*qdd(11)-OMcp15_115*ORcp15_316+OMcp15_315*ORcp15_116-...
 OPcp15_115*RLcp15_316+OPcp15_315*RLcp15_116;
ACcp15_316 = qdd(1)+OMcp15_115*ORcp15_216-OMcp15_212*ORcp15_113-OMcp15_215*ORcp15_116+OPcp15_115*RLcp15_216-OPcp15_212*RLcp15_113-OPcp15_215*...
 RLcp15_116+ORcp15_213*qd(11)+RLcp15_213*qdd(11);

% = = Block_1_0_0_16_1_0 = = 
 
% Symbolic Outputs  

sens.P(1) = POcp15_116;
sens.P(2) = POcp15_216;
sens.P(3) = POcp15_316;
sens.R(1,1) = ROcp15_116;
sens.R(1,2) = ROcp15_216;
sens.R(1,3) = ROcp15_316;
sens.R(2,1) = ROcp15_415;
sens.R(2,2) = ROcp15_515;
sens.R(2,3) = ROcp15_615;
sens.R(3,1) = ROcp15_716;
sens.R(3,2) = ROcp15_816;
sens.R(3,3) = ROcp15_916;
sens.V(1) = VIcp15_116;
sens.V(2) = VIcp15_216;
sens.V(3) = VIcp15_316;
sens.OM(1) = OMcp15_116;
sens.OM(2) = OMcp15_216;
sens.OM(3) = OMcp15_316;
sens.A(1) = ACcp15_116;
sens.A(2) = ACcp15_216;
sens.A(3) = ACcp15_316;
sens.OMP(1) = OPcp15_116;
sens.OMP(2) = OPcp15_216;
sens.OMP(3) = OPcp15_316;
 
% 
case 17, 


% = = Block_1_0_0_17_1_0 = = 
 
% Symbolic Outputs  

sens.P(2) = s.dpt(2,1);
sens.P(3) = q(17);
sens.R(1,1) = (1.0);
sens.R(2,2) = (1.0);
sens.R(3,3) = (1.0);
sens.V(3) = qd(17);
sens.A(3) = qdd(17);

end


% ====== END Task 1 ====== 

  

